rollMatrix = function(M, n_directions, operation){
  
  dimensionX = dim(M)[1]
  dimensionY = dim(M)[2]
  
  rollDown = rbind(M[dimensionX,],M[1:(dimensionX - 1),])
  rollUp = rbind(M[2:dimensionX,],M[1,])
  rollRight = cbind(M[,dimensionY],M[,1:(dimensionY - 1)])
  rollLeft = cbind(M[,2:dimensionY],M[,1])
  
  if(n_directions == 4){
    if(operation == 'sum'){
      rollM = rollDown + rollUp + rollRight + rollLeft
    } else if (operation == 'mean'){
      rollM = (rollDown + rollUp + rollRight + rollLeft + M)/5
    }
  }
  if(n_directions == 8){
    rollRightUp = cbind(rollUp[,dimensionY],rollUp[,1:(dimensionY - 1)])
    rollRightDown = cbind(rollDown[,dimensionY],rollDown[,1:(dimensionY - 1)])
    rollLeftUp = cbind(rollUp[,2:dimensionY],rollUp[,1])
    rollLeftDown = cbind(rollDown[,2:dimensionY],rollDown[,1])
    
    if(operation == 'sum'){
      rollM = rollDown + rollUp + rollRight + rollLeft + 
        rollRightUp + rollRightDown + rollLeftUp + rollLeftDown
    } else if (operation == 'mean'){
      rollM = (rollDown + rollUp + rollRight + rollLeft + 
                 rollRightUp + rollRightDown + rollLeftUp + rollLeftDown + M)/9
    }
  }
  return(rollM)
}
